/*****************************************************************************
*  LPC11U6x SCT Dead time demo program
*
*  Use SCT timer to generate a two-channel double-edge controlled PWM
*  intended for use as a complementary PWM pair with dead-time control
*****************************************************************************/
#include "board.h"

#define DC1        (130)                                   						// duty cycle 1
#define DC2        (135)                                   						// duty cycle 2
#define hperiod    (180)

void SCT1_Init(void);


void SCT1_Init(void)
{

	Chip_SCT_Init(LPC_SCT1);							   						//enable clock for SCT0/1

	Chip_SCT_Config(LPC_SCT1,  SCT_CONFIG_AUTOLIMIT_L);							//two 16-bit timers, clocked internally, auto limit


	Chip_SCT_SetControl(LPC_SCT1, SCT_CTRL_BIDIR_L(0x01));						// Bidir mode, prescaler = 6, SCT clock = 2 MHz

	Chip_SCT_SetMatchCount(LPC_SCT1, SCT_MATCH_0,hperiod);					   	// match 0 @ 10/2MHz = 5 usec (100 KHz PWM freq)
	Chip_SCT_SetMatchReload(LPC_SCT1, SCT_MATCH_0, hperiod);

	Chip_SCT_SetMatchCount(LPC_SCT1, SCT_MATCH_1,DC1);					   		// match 1 used for duty cycle (in 10 steps)
	Chip_SCT_SetMatchReload(LPC_SCT1, SCT_MATCH_1, DC1);

	Chip_SCT_SetMatchCount(LPC_SCT1, SCT_MATCH_2,DC2);					   		// match 1 used for duty cycle (in 10 steps)
	Chip_SCT_SetMatchReload(LPC_SCT1, SCT_MATCH_2, DC2);

	Chip_SCT_EventState(LPC_SCT1, SCT_EVENT_0, ENABLE_ALL_STATES);				// event 0 happens in all states
	Chip_SCT_EventControl(LPC_SCT1, SCT_EVENT_0, (CHIP_SCT_EVENTCTRL_T) ( SCT_IOCOND_FALL	|			// IN_0 falling edge
                                                                        SCT_COMBMODE_IO	));			// COMBMODE[13:12] = match condition only

	Chip_SCT_EventState(LPC_SCT1, SCT_EVENT_1, ENABLE_ALL_STATES);				// event 1 happens in all states
	Chip_SCT_EventControl(LPC_SCT1, SCT_EVENT_1, (CHIP_SCT_EVENTCTRL_T) ( SCT_IOCOND_RAISE	|			// IN_0 rising edge
                                                                        SCT_COMBMODE_IO	  ));			// COMBMODE[13:12] = match condition only

	Chip_SCT_EventState(LPC_SCT1, SCT_EVENT_2, ENABLE_ALL_STATES);				// event 2 happens in all states
	Chip_SCT_EventControl(LPC_SCT1, SCT_EVENT_2, (CHIP_SCT_EVENTCTRL_T) ( SCT_EVECTRL_MATCH1	|			// related to match 1
                                                                        SCT_COMBMODE_MATCH	));			// COMBMODE[13:12] = match condition only

	Chip_SCT_EventState(LPC_SCT1, SCT_EVENT_3, ENABLE_ALL_STATES);				// event 3 happens in all states
	Chip_SCT_EventControl(LPC_SCT1, SCT_EVENT_3, (CHIP_SCT_EVENTCTRL_T) ( SCT_EVECTRL_MATCH2	|			// related to match 2
                                                                        SCT_COMBMODE_MATCH	));			// COMBMODE[13:12] = match condition only



	Chip_SCT_SetOutput(LPC_SCT1, SCT_OUTPUT_0 , (CHIP_SCT_EVENT_T)  ( SCT_EVT_0 |						// event 0 and 2 set OUT0 (blue LED)
                                                                    SCT_EVT_2 ));

	Chip_SCT_ClearOutput(LPC_SCT1, SCT_OUTPUT_0, SCT_EVT_2);					// event 2 clears OUT0 (blue LED)

	Chip_SCT_SetOutput(LPC_SCT1, SCT_OUTPUT_1 , SCT_EVT_3);						// event 3 sets OUT1 (red LED)


	Chip_SCT_ClearOutput(LPC_SCT1, SCT_OUTPUT_1, (CHIP_SCT_EVENT_T)  (  SCT_EVT_0 |
                                                                      SCT_EVT_3 ));					// event 0 and 3 clear OUT1 (red LED)

	Chip_SCT_SetConflictResolution(LPC_SCT1, 0, 0x0F);							// toggle OUT0 and OUT1 on conflict

	Chip_SCT_Output(LPC_SCT1, 0x01 );											// default set OUT0 and and clear OUT1


	LPC_SCT1->STOP_L           = (1 << 0);                 						// event 0 will stop the timer
	LPC_SCT1->EVEN             = (1 << 1);                 						// event 1 will generate an irq

	NVIC_EnableIRQ(SCT0_1_IRQn);                           						// enable SCT0/1 interrupt

	Chip_SCT_ClearControl(LPC_SCT1, SCT_CTRL_HALT_L);							// unhalt it by clearing bit 2 of the CTRL register
}





void SCT0_1_IRQHandler(void)
{
	Chip_SCT_SetControl(LPC_SCT1, SCT_CTRL_CLRCTR_L);	// clear the L counter

	Chip_SCT_ClearControl(LPC_SCT1, SCT_CTRL_STOP_L);	// start the L counter

	Chip_SCT_ClearEventFlag(LPC_SCT1, SCT_EVT_1);		// clear event 1 interrupt flag

}

int main (void)
{

	SystemCoreClockUpdate();
	Board_Init();


	Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_IOCON);				// enable clock for IOCON


	Chip_IOCON_PinMuxSet(LPC_IOCON, 2, 8 , 0x00000081);				// P2_8 is SCT0_IN0
	Chip_IOCON_PinMuxSet(LPC_IOCON, 2,16 , 0x00000081);				// P2_16 is SCT0_OUT0
	Chip_IOCON_PinMuxSet(LPC_IOCON, 2,17 , 0x00000081);				// P2_17 is SCT0_OUT1

	SCT1_Init();                                   					// Initialize SCT


	while (1)                                              			// loop forever
	{
		__WFI();
	}
}

